% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getCharacterizationDemographics}
\alias{getCharacterizationDemographics}
\title{Extract the binary age groups for the cases and targets}
\usage{
getCharacterizationDemographics(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetId = NULL,
  outcomeId = NULL,
  type = "age"
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetId}{An integer corresponding to the target cohort ID}

\item{outcomeId}{Am integer corresponding to the outcome cohort ID}

\item{type}{A character of 'age' or 'sex'}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unique identifier of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome unique identifier}
 \item{minPriorObservation the minimum required observation days prior to index for an entry}
 \item{outcomeWashoutDays patients with the outcome occurring within this number of days prior to index are excluded (NA means no exclusion)}
\item{riskWindowStart the number of days ofset the start anchor that is the start of the time-at-risk}
\item{startAnchor the start anchor is either the target cohort start or cohort end date}
\item{riskWindowEnd the number of days ofset the end anchor that is the end of the time-at-risk}
\item{endAnchor the end anchor is either the target cohort start or cohort end date}
\item{covariateName the name of the feature}
\item{sumValue the number of cases who have the feature value of 1}
\item{averageValue the mean feature value}
}
}
\description{
This function extracts the age group feature extraction results for cases and targets corresponding to specified target and outcome cohorts.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
# example code

conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

ageData <- getCharacterizationDemographics(
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
