% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Database.R
\name{getDatabaseDetails}
\alias{getDatabaseDetails}
\title{Extract the database used in the analyses}
\usage{
getDatabaseDetails(
  connectionHandler,
  schema,
  databaseTable = "database_meta_data"
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseFullName the full name of the database}
 \item{databaseName the friendly name of the database}
 \item{cdmHolder the license holder of the database}
 \item{sourceDescription a description of the database}
 \item{sourceDocumentationReference a link to the database information document}
 \item{cdmEtlReference a link to the ETL document}
 \item{sourceReleaseDatethe release date for the source database}
 \item(cdmReleaseDate the release date for the database mapped to the OMOP CDM)
 \item{cdmVersion the OMOP CDM version of the database}
 \item{cdmVersionConceptId the CDM version concept ID}
 \item{vocabularyVersion the database's vocabulary version}
 \item{databaseId a unique identifier for the database}
 \item{maxObsPeriodEndDate the last observational period end date in the database}
 }
}
\description{
This function extracts the databases and their information.
}
\details{
Specify the connectionHandler, the schema and the database table name
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

ir <- getIncidenceRates(
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\concept{Database}
