% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionDiagnostics}
\alias{getPredictionDiagnostics}
\title{Extract the model design diagnostics for a specific development database}
\usage{
getPredictionDiagnostics(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  modelDesignIds = NULL,
  threshold1_2 = 0.9
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{modelDesignIds}{The identifier for a model design  to restrict results to}

\item{threshold1_2}{A threshold for probast 1.2}
}
\value{
Returns a data.frame with the columns:
\itemize{   
 \item{modelDesignId the unique identifier for the model design}
 \item{diagnosticId the unique identifier for diagnostic result}
 \item{developmentDatabaseName the name for the database used to develop the model}
 \item{developmentTargetName the name for the development target population}
 \item{developmentOutcomeName the name for the development outcome}
 \item{probast1_1 Were appropriate data sources used, e.g., cohort, RCT, or nested case-control study data?}
 \item{probast1_2 Were all inclusions and exclusions of paticipants appropriate?}
 \item{probast2_1 Were predictors defined and assessed in a similar way for all participants?}
 \item{probast2_2 Were predictors assessments made without knowledge of outcome data?}
 \item{probast2_3 All all predictors available at the time the model is intended to be used?}
 \item{probast3_4 Was the outcome defined and determined in a similar way for all participants?}
 \item{probast3_6 Was the time interval between predictor assessment and outcome determination appropriate?}
 \item{probast4_1 Were there a reasonable number of participants with the outcome?}
 }
}
\description{
This function extracts the PROBAST diagnostics
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and (optionally) a modelDesignId and threshold1_2 a threshold value to use for the PROBAST 1.2
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

diag <- getPredictionDiagnostics(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Prediction: 
\code{\link{getFullPredictionPerformances}()},
\code{\link{getPredictionAggregateTopPredictors}()},
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionCovariates}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionLift}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionOutcomes}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTargets}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
