% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{NodalProstate_df}
\alias{NodalProstate_df}
\title{Nodal Involvement in Prostate Cancer}
\format{
A data frame with 53 observations and 7 variables:
\describe{
  \item{m}{Estimated probability of nodal involvement (numeric).}
  \item{r}{Predicted nodal involvement risk (numeric).}
  \item{aged}{Age group of the patient (factor with 2 levels).}
  \item{stage}{Cancer stage (factor with 2 levels).}
  \item{grade}{Tumor grade (factor with 2 levels).}
  \item{xray}{X-ray result (factor with 2 levels).}
  \item{acid}{Acid phosphatase test result (factor with 2 levels).}
}
}
\source{
Data taken from the SMPracticals package.
}
\usage{
data(NodalProstate_df)
}
\description{
This dataset, NodalProstate_df, is a data frame containing data on 53 patients diagnosed with prostate cancer. The dataset records several clinical and diagnostic factors to assess nodal involvement without surgery. Nodal involvement is a critical factor in determining the treatment strategy for prostate cancer patients.
}
\details{
The dataset name has been kept as 'NodalProstate_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
