% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpwexp.R
\name{rpwexp}
\alias{rpwexp}
\title{The Piecewise Exponential Distribution}
\usage{
rpwexp(n = 100, failRates = tibble(duration = c(1, 1), rate = c(10, 20)))
}
\arguments{
\item{n}{Number of observations to be generated.}

\item{failRates}{A tibble containing \code{duration} and \code{rate} variables.
\code{rate} specifies failure rates during the corresponding interval duration
specified in \code{duration}. The final interval is extended to be infinite
to ensure all observations are generated.}
}
\value{
A vector of random event times following piecewise exponential distribution.
}
\description{
The piecewise exponential distribution allows a simple method to specify a distribtuion
where the hazard rate changes over time. It is likely to be useful for conditions where
failure rates change, but also for simulations where there may be a delayed treatment
effect or a treatment effect that that is otherwise changing (e.g., decreasing) over time.
\code{rpwexp()} is to support simulation of both the Lachin and Foulkes (1986) sample size
method for (fixed trial duration) as well as the Kim and Tsiatis(1990) method
(fixed enrollment rates and either fixed enrollment duration or fixed minimum follow-up).
}
\details{
Using the \code{cumulative=TRUE} option, enrollment times that piecewise constant over
time can be generated.
}
\examples{
# get 10k piecewise exponential failure times
# failure rates are 1 for time 0-.5, 3 for time .5 - 1 and 10 for >1.
# intervals specifies duration of each failure rate interval
# with the final interval running to infinity
x <- rpwexp(10000, failRates=tibble::tibble(rate = c(1, 3, 10), duration = c(.5,.5,1)))
plot(sort(x),(10000:1)/10001,log="y", main="PW Exponential simulated survival curve",
xlab="Time",ylab="P{Survival}")
# exponential failure times
x <- rpwexp(10000, failRates=tibble::tibble(rate = 5, duration=1))

plot(sort(x),(10000:1)/10001,log="y", main="Exponential simulated survival curve",
     xlab="Time",ylab="P{Survival}")

}
