% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_sf_precision_mat.R
\name{make_sf_precision_mat}
\alias{make_sf_precision_mat}
\title{Generate scale-free network skeleton and simulates corresponding precision matrix}
\usage{
make_sf_precision_mat(
  e = 1,
  power = 1,
  p = 20,
  lower = 0.2,
  upper = 0.5,
  diag = 0.1
)
}
\arguments{
\item{e}{Numeric constant, the number of edges to add in each time step, see sample_pa().}

\item{power}{Numeric constant, the power of the preferential attachment for scale-free network, the default is 1, , see sample_pa().}

\item{p}{A positive integer, the number of vertices.}

\item{lower}{A positive number, lower limits of the uniform distribution.}

\item{upper}{A positive number, upper limits of the uniform distribution.}

\item{diag}{A small positive number to be added to diagonal elements, which guarantees the precision matrix is positive definite.}
}
\value{
A precision matrix of size p by p.
}
\description{
A utility function generates scale-free network skeleton and simulates corresponding precision matrix. The non-zero elements of the precision matrix are generated randomly from a uniform distribution with parameters (-upper, -lower) UNION (lower, upper).
}
\examples{
Omega = make_sf_precision_mat(e=1, p=10)
}
