% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{print.mpPLMIX}
\alias{print.mpPLMIX}
\title{Print of the MAP estimation algorithm for a Bayesian mixture of Plackett-Luce models}
\usage{
\method{print}{mpPLMIX}(x, ...)
}
\arguments{
\item{x}{Object of class \code{mpPLMIX} returned by the \code{mapPLMIX} or \code{mapPLMIX_multistart} function.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\description{
\code{print} method for class \code{mpPLMIX}. It shows some general information on the MAP estimation procedure for a Bayesian mixture of Plackett-Luce models.
}
\examples{

## Print of the MAP procedure with a single starting point
data(d_carconf)
MAP <- mapPLMIX(pi_inv=d_carconf, K=ncol(d_carconf), G=3)
print(MAP)

## Print of the MAP procedure with 5 starting points
MAP_multi <- mapPLMIX_multistart(pi_inv=d_carconf, K=ncol(d_carconf), G=3, n_start=5)
print(MAP_multi)
}
\seealso{
\code{\link{mapPLMIX}} and \code{\link{mapPLMIX_multistart}}
}
\author{
Cristina Mollica and Luca Tardella
}
