% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_functional.R
\name{estimate.functional}
\alias{estimate.functional}
\title{Estimate Functional}
\usage{
estimate.functional(iden.fct = quantiles, model = constant,
  theta0 = NULL, Y, X, stateVariable = NULL, other_data = NULL,
  instruments = c("X", "lag(Y)"), prewhite = F, kernel = "Bartlett",
  bw = bwNeweyWest1987, ...)
}
\arguments{
\item{iden.fct}{identification function. Standard choice is \code{\link{quantiles}}. The alternative is \code{\link{expectiles}}.}

\item{model}{specification model. See \code{\link{constant}} for the simplest example and further suggestions.}

\item{theta0}{starting value for optimization}

\item{Y}{realized values}

\item{X}{forecasts}

\item{stateVariable}{state variable(s) as vector or matrix of column vectors.}

\item{other_data}{optional for construction of instruments}

\item{instruments}{instruments (list of character describing instruments or matrix of actual instruments). Use "const" for just the constant as instrument. Standard ist c("X","lag(Y)"), which uses the constant, the forecast and the lagged value of the outcome.}

\item{prewhite}{logical or integer. Should the estimating functions be prewhitened? Standard is FALSE.
If TRUE or greater than 0 a VAR model of order as.integer(prewhite) is fitted. (see ?gmm)}

\item{kernel}{choose kernel for HAC-covariance estimation (see ?gmm). Standard is "Bartlett" Kernel as proposed in Newey and West (1987).}

\item{bw}{function describing bandwidth selection (see ?gmm for alternatives). Standard is that the bandwidth depends on the sample length $T$ by $m(T)=T^{1/5}$.}

\item{...}{other parameters for gmm function (see ?gmm)}
}
\value{
Object of type \code{pointfore}. Use \code{summary} and \code{plot} methods to illustrate results.
}
\description{
Estimates the parameter in a specification model for state-dependent quantile or expectile forecasts.
For additional detail see the vignettes of the PointFore package.
}
\examples{
# estimate constant quantile level of GDP forecast
res <- estimate.functional(Y=GDP$observation, X=GDP$forecast,
model=constant)
summary(res)
plot(res)

# estimate constant quantile level with only the constant as instrument
res <- estimate.functional(Y=GDP$observation, X=GDP$forecast,
model=constant, instruments="const")
summary(res)

\dontrun{
# estimate constant expectile level
res <- estimate.functional(Y=GDP$observation, X=GDP$forecast,
model=constant, instruments="const", iden.fct = expectiles)
summary(res)
plot(res)

# estimate state-dependent quantile level with linear probit specification model
res <- estimate.functional(Y=GDP$observation, X=GDP$forecast,
stateVariable = GDP$forecast, model = probit_linear)
summary(res)
plot(res)
}
}
