% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_functional.R
\name{quantiles}
\alias{quantiles}
\title{Identification function for state-dependent quantiles}
\usage{
quantiles(x, y, stateVariable, theta, model, ...)
}
\arguments{
\item{x}{forecast}

\item{y}{realization}

\item{stateVariable}{state variable}

\item{theta}{model parameter to be estimated}

\item{model}{model function}

\item{...}{...}
}
\description{
Main alternative to estimating state-dependent quantiles based on the quantile identification function are state-dependent \code{\link{expectiles}}.
}
\examples{
### estimate expectation of identification function for quantile forecasts

set.seed(1)
y <- rnorm(1000)
x <- qnorm(0.6)
# expectation of identification with quantile level 0.6 is zero
mean(quantiles(x,y,0,0.6,constant))
# expectation of identification function with different quantile level
# (0.5 is the median) is not zero
mean(quantiles(x,y,0,0.5, constant))
}
\seealso{
Other identification functions: \code{\link{expectiles}}
}
\concept{identification functions}
