#' Dataset of Eucalyptus globulus (common name: blue gum) sightings collected across the Koala conservation reserve on Phillip island (Australia) between 1993 and 2004. Two marks are considered from this dataset: "koala" which describes the number of koala visits to each tree, and "food" which is some index of the palatability of the leaves.
#' @name Koala
#' @docType data
#' @keywords data
#' @format \code{eucTrees} is a \code{data.frame} object (1284 observations; 6 variables) with the following columns:
#' \describe{
#'\item{E}{Latitude of the observation.}
#'\item{N}{Longitude of the observation.}
#'\item{FOOD}{Some value of the palatability of the leaves of the trees.}
#'\item{koala}{The number of koala sightings per tree.}
#'\item{nitrogen}{Total nitrogen (mg.g-1 DM).}
#'\item{dbh}{Diameter at breast hight of the trees (cm).}
#' }
#' 
#' @references Moore, B.D., Lawler, I.R., Wallis, I.R., Collin, B.M. and Foley, W.J. (2010). Palatability mapping: a koala’s eye view of spatial variation in habitat quality. Ecology 91 (11): 3165-3176.
NULL