% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoweREST.R
\name{PoweREST}
\alias{PoweREST}
\title{Bootstrap resampling and power calculation upon ST data}
\usage{
PoweREST(Seurat_obj,cond,replicates=1,spots_num,
iteration=100,random_seed=1,pvalue=0.05,...)
}
\arguments{
\item{Seurat_obj}{A \href{https://CRAN.R-project.org/package=Seurat}{Seurat} object.}

\item{cond}{The name of the variable that indicates different conditions which is also stored in the
meta.data of the Seurat_obj and should be in character type.}

\item{replicates}{The number of sample replicates per group.}

\item{spots_num}{The number of spots per replicate.}

\item{iteration}{The number of iterations of the resampling.}

\item{random_seed}{To set a random seed.}

\item{pvalue}{The pvalue that will be considered significant.}

\item{...}{DE test to use other than the default Wilcoxon test.}
}
\value{
A list of values containing the power, average log2FC and percentage of spots detecting the gene among
the resampling data, the replicate value and the spots number per slice specified by the user and corresponding genes' name.
}
\description{
This function performs bootstrap resampling upon a Seurat subject under each condition
to resemble the real dataset which allows the exact power calculation, and perform DE analysis.
Users can specify the test they would like to perform for the DE analysis in '...' which should not contain
min.pct and logfc.threshold or other parameters attempt to pre-filter genes, as we specify min.pct and logfc.threshold as 0s
to calculate power for all the genes available. Therefore it may take one night to run if the ST data owns over thousands of genes.
To speed up this process, one may want to try function 'PoweREST_subset' where the pre-filter of genes are included in this process.
}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
