% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_XGBoost.R
\name{fit_XGBoost}
\alias{fit_XGBoost}
\title{Fit with XGBoost}
\usage{
fit_XGBoost(power,avg_log2FC,avg_PCT,replicates,filter_zero=TRUE,
max_depth=6,learning_rate=0.3,nrounds=100)
}
\arguments{
\item{power}{The raw power values.}

\item{avg_log2FC}{The corresponding log2FC values.}

\item{avg_PCT}{The corresponding PCT values.}

\item{replicates}{The corresponding replicates number.}

\item{filter_zero}{Whether the user would like to filter to remove the power values being 0. Default=TRUE.}

\item{max_depth}{Maximum depth of a tree. Default=6.}

\item{learning_rate}{Control the learning rate: scale the contribution of each tree by a factor of 0 < learning_rate < 1 when it is added to the current approximation. Used to prevent overfitting by making the boosting process more conservative. Default=0.3.}

\item{nrounds}{Max number of boosting iterations.}
}
\value{
A object of class 'xgb.Booster'. More information about the content of a 'xgb.Booster' object can be found
at the document of R package \href{https://CRAN.R-project.org/package=xgboost}{xgboost}.
}
\description{
This function estimates the power values based on XGBoost under 3-dimensional monotone constraints upon avg_log2FC, avg_PCT
and replicates. This function is recommended when there exist crossings between power surfaces fitted by 'fit_powerest' and
used for estimating local power values.
}
\examples{
data(power_example)
# Fit the local power surface of avg_log2FC_abs between 1 and 2
avg_log2FC_abs_1_2<-dplyr::filter(power_example,avg_log2FC_abs>1 & avg_log2FC_abs<2)
# Fit the model
bst<-fit_XGBoost(power_example$power,avg_log2FC=power_example$avg_log2FC_abs,
avg_PCT=power_example$mean_pct,replicates=power_example$sample_size)

}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
