% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sq.R
\name{sq}
\alias{sq}
\title{Determine the Number of Breaks Using the SQ(l|l+1) Test}
\usage{
sq(y, x, v.tau, n.size = 1, m.max, trim.size, mat.date)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}).}

\item{v.tau}{A numeric value representing the quantile of interest.}

\item{n.size}{An integer specifying the size of the cross-section (\eqn{N}).}

\item{m.max}{An integer specifying the maximum number of breaks allowed.}

\item{trim.size}{A numeric value specifying the trimming size (the minimum length of a segment).}

\item{mat.date}{A numeric matrix of break dates.}
}
\value{
A list with the following components:
\describe{
\item{\code{test}}{A numeric vector of SQ test statistics.}
\item{\code{cv}}{A numeric matrix of critical values for the SQ test, with the 1st, 2nd, and 3rd rows corresponding to the 10\%, 5\%, and 1\% significance levels.}
\item{\code{date}}{A numeric matrix of break dates, with the 1st, 2nd, and 3rd rows corresponding to the 10\%, 5\%, and 1\% significance levels.}
\item{\code{nbreak}}{A numeric vector indicating the number of breaks at the 10\%, 5\%, and 1\% significance levels.}
}
}
\description{
This procedure sequentially applies the SQ test to determine the number of breaks, based on a single quantile.
}
\examples{
\donttest{
## data 
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")] 

## quantile 
v.tau = 0.8 

# cross-sectional size 
n.size = 1 

# the maximum number of breaks 
m.max = 3

## trim 
T.size    = length(y)
trim.e    = 0.2
trim.size = round(T.size * trim.e)  #minimum length of a regime

# get.long 
out.long   = gen.long(y, x, v.tau, n.size, trim.size)
mat.long.s = out.long$mat.long  ## for individual quantile

# mat.date 
mat.date = brdate(y, x, n.size, m.max, trim.size, mat.long.s)

# sq 
result = sq(y, x, v.tau, n.size, m.max, trim.size, mat.date)
print(result)
}

}
