% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_quantile_estimation.R
\name{sample_quantile_estimation}
\alias{sample_quantile_estimation}
\title{Estimate Quantiles within the Sample}
\usage{
sample_quantile_estimation(samp = NULL, probs = NULL, bootstrap_sims = NULL)
}
\arguments{
\item{samp}{Sample of data to model}

\item{probs}{Probabilities of interest to generate the max_k line}

\item{bootstrap_sims}{Number of bootstrap simulations to estimate the quantiles}
}
\value{
Returns estimated quantiles for the chosen probabilities.
}
\description{
\code{sample_quantile_estimation} returns the estimated quantiles for the chosen probabilities from the input sample.
This method uses the sample quantile method number 8 from the default quantile function.
}
\examples{
samp <- rnorm(1e3, mean = 100, sd = 10)
probs <- c(1-1e-1, 1-0.5e-1, 1-1e-2)
bootstrap_training_sims <- 100
estimated_quantiles <- sample_quantile_estimation(samp = samp,
                                                  probs = probs,
                                                  bootstrap_sims = bootstrap_training_sims)
}
\keyword{RESTK}
