% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_star_habitable_zone.R
\name{calculate_star_habitable_zone}
\alias{calculate_star_habitable_zone}
\title{Calculate star's habitable zone}
\usage{
calculate_star_habitable_zone(st_lum, log_lum = TRUE)
}
\arguments{
\item{st_lum}{A numeric Stellar luminosity value (log10(L/Lsun) or linear).}

\item{log_lum}{A logical value. If \code{TRUE} assumes \code{st_lum} is logarithmic. Defaults to \code{TRUE}.}
}
\value{
A numeric vector of 2 elements
where first is habitable zone inner radius and second is the outer radius.
}
\description{
Calculates star's habitable zone inner and outer radius,
based on star's luminosity.
}
\examples{
calculate_star_habitable_zone(0) # habitable zone for sun, with logarithmic units
calculate_star_habitable_zone(1, log_lum = FALSE) # habitable zone for sun, with linear units

}
