% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_stellar_flux.R
\name{calculate_stellar_flux}
\alias{calculate_stellar_flux}
\title{Calculate stellar flux value}
\usage{
calculate_stellar_flux(st_lum, pl_orbsmax, log_lum = TRUE, unit = "relative")
}
\arguments{
\item{st_lum}{Numeric. Stellar luminosity (log10(L/Lsun) or linear).}

\item{pl_orbsmax}{Numeric. Orbital distance in AU.}

\item{log_lum}{Logical. If TRUE, assumes \code{st_lum} is in log10(L / Lsun). Defaults to TRUE.}

\item{unit}{Character. Either \code{"relative"} (default) or \code{"wm2"} to convert to W/m².}
}
\value{
Numeric. Stellar flux (relative or in W/m²).
}
\description{
Calculate stellar flux value
}
\details{
This function calculates the stellar flux based on provided values.
It assumes luminosity is either logarithmic (log10 of L/Lsun) or linear, and optionally
converts flux to absolute units (W/m²) if requested.

Stellar flux is the amount of energy from a star that reaches a given area per unit time.
}
\examples{
# Solar-type star, Earth-like orbit
calculate_stellar_flux(st_lum = 0, pl_orbsmax = 1)
# Linear luminosity input (not log), 5x Sun at 2 AU
calculate_stellar_flux(st_lum = 5, pl_orbsmax = 2, log_lum = FALSE)
# Output in absolute units (W/m²), Earth-like conditions
calculate_stellar_flux(st_lum = 0, pl_orbsmax = 1, unit = "wm2")

}
