% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_planet_type.R
\name{classify_planet_type}
\alias{classify_planet_type}
\title{Classify Planet Type}
\usage{
classify_planet_type(pl_bmasse, pl_eqt, pl_orbeccen, pl_dens)
}
\arguments{
\item{pl_bmasse}{Numeric. Planetary mass in Earth masses. Must be > 0.}

\item{pl_eqt}{Numeric. Planetary equilibrium temperature in Kelvin. Must be > 0.}

\item{pl_orbeccen}{Numeric. Orbital eccentricity. Must be > 0.}

\item{pl_dens}{Numeric. Planetary density in g/cm³. Must be > 0.}
}
\value{
A character string containing a 4-character planet classification code.
}
\description{
This function returns a compact four-character code
representing the classification of an exoplanet
based on its mass, equilibrium temperature, orbital eccentricity, and density.

The classification code is composed of four parts:
\enumerate{
\item \strong{Mass class:}
\itemize{
\item \code{M}: Mercury-like planets (< 0.22 Earth masses)
\item \code{E}: Earth-like planets (0.22–2.2 Earth masses)
\item \code{S}: Super-Earths (2.2–22 Earth masses)
\item \code{N}: Neptune-like planets (22–127 Earth masses)
\item \code{J}: Jupiter-like giants (127–4450 Earth masses)
\item \code{D}: Degenerate-matter/brown dwarf-like objects (>= 4450 Earth masses)
}
\item \strong{Temperature class:}
\itemize{
\item \code{F}: Frozen (T < 250 K)
\item \code{W}: Temperate/water zone (250–450 K)
\item \code{G}: Gaseous (450–1000 K)
\item \code{R}: Roasters (>= 1000 K)
}
\item \strong{Eccentricity:}
\itemize{
\item First decimal digit of orbital eccentricity.
For example, 0.26 → \code{3} → appended as \code{3}.
}
\item \strong{Density-based surface/composition class:}
\itemize{
\item \code{g}: Gas-dominated (< 0.25 g/cm³)
\item \code{w}: Water/ice-rich (0.25–2 g/cm³)
\item \code{t}: Terrestrial/rocky (2–6 g/cm³)
\item \code{i}: Iron-rich (6–13 g/cm³)
\item \code{s}: Super-dense (>= 13 g/cm³)
}
}
}
\examples{
classify_planet_type(1.0, 288, 0.0167, 5.5)   # Earth-like: "EW0t"
classify_planet_type(318, 1300, 0.05, 1.3)    # Hot Jupiter: "JR3w"
classify_planet_type(0.1, 180, 0.2, 0.1)      # Cold, light, low-density: "MF2g"

}
