% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateResults.R
\name{computePerfMeas}
\alias{computePerfMeas}
\title{Function for computing performance measurements}
\usage{
computePerfMeas(
  analyte,
  algo,
  resRIs,
  subTable,
  RIperc = c(0.025, 0.975),
  cutoffZ = 5
)
}
\arguments{
\item{analyte}{(character) specifiyng current analyzed analyte}

\item{algo}{(character)    specifying used algorithm}

\item{resRIs}{(data.frame) with all calculated reference intervals}

\item{subTable}{(data.frame) containing all information about the simulated test sets}

\item{RIperc}{(numeric) vector specifying the percentiles for the reference interval, default: 0.025 and 0.975}

\item{cutoffZ}{(numeric) specifying if a cutoff should be used to classify results as implausible and exclude from analysis}
}
\value{
updated data frame with computed performance measures
}
\description{
Function for computing performance measurements
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
