% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scale_image.R
\name{scale_color_image}
\alias{scale_color_image}
\alias{scale_colour_image}
\alias{scale_fill_image}
\title{Image color scales}
\usage{
scale_color_image(..., image, n = 3, choice = mean, volume = FALSE,
  discrete = TRUE)

scale_colour_image(..., image, n = 3, choice = mean, volume = FALSE,
  discrete = TRUE)

scale_fill_image(..., image, n = 3, choice = mean, volume = FALSE,
  discrete = TRUE)
}
\arguments{
\item{...}{parameters to \code{discrete_scale} or \code{scale_fill_gradientn}}

\item{image}{Matrix The image from which the palette will be extracted from. Should
be a 3 (or more) dimensional matrix. The output of a function such as \code{readJPG()}
or \code{readPNG()} are suitable as \code{image}.}

\item{n}{For continuous color scales, you may optionally pass in an integer, n.
This allows some control over the scale, if n is too large the scale has too many
colors and ceases to be meaningul. n = 3 to n = 5 is recommended.}

\item{choice}{Function Defines how the color will be chosen from the final color cubes.
The default choice is to take the \code{mean} value of the image cube, but other choices
may return a subjectively superior scale. Try \code{median}, or \code{min}, or \code{max}, or
whatever summary statistic suits your fancy.}

\item{volume}{Logical volume controls the method for choosing which color cube to split
at each iteration of the algorithm. The default choice (when \code{volume = FALSE}) is to
choose the cube which contains the largest extent (that is, the largest range
of some color). When \code{volume = TRUE}, the cube with the largest volume is chosen to split.
Occasionally, setting to \code{TRUE} returns a better palette.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}
}
\description{
Uses the image color scale.
}
\details{
For \code{discrete == TRUE} (the default) the function will return a \code{discrete_scale} with the plot-computed
number of colors. All other arguments are as to
\link[ggplot2]{scale_fill_gradientn} or \link[ggplot2]{scale_color_gradientn}.

See \link{image_palette} for more information on the color scale.
}
\examples{
library(ggplot2)

# ripped from the pages of ggplot2
your_image <- jpeg::readJPEG(system.file("img", "Rlogo.jpg", package="jpeg"))
display_image(your_image)

#Discrete scale example
p <- ggplot(mtcars, aes(wt, mpg))
p + geom_point(size=4, aes(colour = factor(cyl))) +
    scale_color_image(image = your_image) +
    theme_bw()

#Continuous scale example
dsub <- subset(diamonds, x > 5 & x < 6 & y > 5 & y < 6)
dsub$diff <- with(dsub, sqrt(abs(x-y))* sign(x-y))
d <- ggplot(dsub, aes(x, y, colour=diff)) + geom_point()
d + scale_color_image(image = your_image, discrete=FALSE) + theme_bw()
}
\seealso{
\code{\link{median_cut}} \code{\link{image_palette}} \code{\link{vbox}}
\code{\link{display_image}}
}

