% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_characters.R
\name{rx_tab}
\alias{rx_tab}
\title{Match a tab character.}
\usage{
rx_tab(.data = NULL, inverse = FALSE)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{ \%>\% }}

\item{inverse}{Invert match behavior, defaults to \code{FALSE} (match
tabs). Use \code{TRUE} to \emph{not} match tabs.}
}
\description{
Match a tab character.
}
\details{
This function is looks for tabs with the following
expression: \code{\\t}
\enumerate{
  \item Tab character: \url{https://codepoints.net/U+0009}
}
}
\examples{
rx_tab()
rx_tab(inverse = TRUE)

# create an expression
x <- rx_tab()

# create input
string <- "foo\tbar"

# extract match
regmatches(string, regexpr(x, string))
}
