% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{downloadExperiment}
\alias{downloadExperiment}
\title{Makes a download request from the server.}
\usage{
downloadExperiment(sourceURL, experimentName, destination = "default.csv",
  auth = FALSE)
}
\arguments{
\item{sourceURL}{The source URL for the experiment}

\item{experimentName}{The experiment name as set in \code{settings.js}}

\item{destination}{The file to download. By default, all uploaded results are
saved in \code{default.csv}, which is the default file to download.}

\item{auth}{Whether authentication is needed}
}
\value{
The downloaded data set as data frame
}
\description{
This function downloads the results of an experiment.
}
\examples{
\dontrun{
downloadExperiment("https...s3.amazonaws.com.myexperiment.index.html", "testing1")
downloadExperiment("https...s3.amazonaws.com.myexperiment.index.html", "running", auth = TRUE)
}
}
\seealso{
Other download: \code{\link{getDestinations}},
  \code{\link{getUsers}}
}

