% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{prepare.server.URL}
\alias{prepare.server.URL}
\title{Server URL preparation.}
\usage{
prepare.server.URL(server)
}
\arguments{
\item{server}{A server name.}
}
\value{
A clean URL with protocol prefix and trailing slash.
}
\description{
Prepares the server URL by checking for the presence of a protocol
prefix, and prefixing \code{http://} if there is none. Also, returns
the URL with a trailing \code{/} if that was not present either.
}
\examples{
prepare.server.URL("db.phonologist.org")
prepare.server.URL("https://myserver.com/")

}
\seealso{
Other development: \code{\link{API.request}},
  \code{\link{checkAuthentication}},
  \code{\link{create.API.request.URL}},
  \code{\link{server.version}}
}

