#' baseball data
#'
#' 
#'Statistics on 797 baseball players, compiled by Jenifer Boshes from the rosters
#'of all major league teams in November 2004. Missing values (for variables pball, intwalk, hbp, sacrfly; all other variables 
#'have complete data) are coded as NA.
#'
#'
#' @format This data frame contains the following columns:
#' 
#' \describe{
#' \item{team:}{team played for at the beginning of the season}
#' 
#' \item{leagueid:}{AL or NL}
#' 
#' \item{player:}{a unique identifier for each baseball player}
#' 
#' \item{salary:}{player salary in 2004}
#' 
#' \item{pos:}{primary position coded as P, C, 1B, 2B, 3B, SS, RF, LF, or CF}
#'  
#'  \item{gplay:}{games played}
#'  
#'  \item{gstart:}{games started}
#'  
#'  \item{inning:}{number of innings}
#'  
#'  \item{putout:}{number of putouts}
#'  
#'  \item{assist:}{number of assists}
#'  
#'  \item{error:}{errors}
#'  
#'  \item{dplay:}{number of double plays}
#'  
#'  \item{pball:}{number of passed balls (only applies to catchers)}
#'  
#'  \item{gbat:}{number of games that player appeared at bat}
#'  
#'  \item{atbat:}{number of at bats}
#'  
#'  \item{run:}{number of runs scored}
#'  
#'  \item{hit:}{number of hits}
#'  
#'  \item{secbase:}{number of doubles}
#'  
#'  \item{thirdbase:}{number of triples}
#'  
#'  \item{homerun:}{number of home runs}
#'  
#'  \item{rbi:}{number of runs batted in}
#'  
#'  \item{stolenb:}{number of stolen bases}
#'  
#'  \item{csteal:}{number of times caught stealing}
#'  
#'  \item{walk:}{number of times walked}
#'  
#'  \item{strikeout:}{number of strikeouts}
#'  
#'  \item{intwalk:}{number of times intentionally walked}
#'  
#'  \item{hbp:}{number of times hit by pitch}
#'  
#'  \item{sacrhit:}{number of sacrifice hits}
#'  
#'  \item{sacrfly:}{number of sacrifice flies}
#'  
#'  \item{gidplay:}{grounded into double play}
#'  }
#'  
#'  
#'  
#'  
#'
#' @docType data
#'
#' @usage data(baseball)
#'
#'
#'
#' @keywords datasets
#' 
#'@references Forman, S. L. (2004). Baseball-reference.com—Major league statistics and information.
#' www.baseball-reference.com (accessed November 2004).
#'
#' @references Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.
#' 
#'@references Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
#' 
#'
#' 
#' 
#' 
"baseball"

