% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_codes.R
\name{check_codes}
\alias{check_codes}
\title{Check matches of reported codes in SMHI's SHARK codelist}
\usage{
check_codes(
  data,
  field = "sample_project_name_en",
  code_type = "PROJ",
  match_column = "Description/English translate",
  clean_cache_days = 30,
  verbose = TRUE
)
}
\arguments{
\item{data}{A tibble (or data.frame) containing the codes to check.}

\item{field}{Character; name of the column in \code{data} that contains the codes
to be validated against the SHARK codelist. If a cell contains multiple
codes separated by commas, each code is validated separately.
Default is \code{"sample_project_name_en"}.}

\item{code_type}{Character; the type of code to check (e.g., \code{"PROJ"}).
Defaults to \code{"PROJ"}.}

\item{match_column}{Character; the column in the SHARK codelist to match
against. Must be one of \code{"Code"} or \code{"Description/English translate"}. Defaults to
\code{"Description/English translate"}.}

\item{clean_cache_days}{Numeric; if not \code{NULL}, cached SHARK code Excel files
older than this number of days will be automatically deleted and replaced
by a new download. Defaults to 30. Set to \code{NULL} to disable automatic cleanup.}

\item{verbose}{Logical. If TRUE, messages will be displayed during execution. Defaults to TRUE.}
}
\value{
A \code{tibble} with unique reported codes (after splitting comma-separated
entries) and a logical column \code{match_type} indicating if they exist in the
SHARK codelist.
}
\description{
This function checks whether the codes reported in a specified column of a
dataset (e.g., project codes, ship codes, etc.) are present in the
official SHARK codelist provided by SMHI. If a cell contains multiple codes
separated by commas, each code is checked individually. The function downloads
and caches the codelist if necessary, compares the reported values against
the valid codes, and returns a \code{tibble} showing which codes matched.
Informative messages are printed if unmatched codes are found.
}
\seealso{
\code{\link[=get_shark_codes]{get_shark_codes()}} to get the current code list.

\code{\link[=clean_shark4r_cache]{clean_shark4r_cache()}} to manually clear cached files.
}
