% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shark_api_functions.R
\name{get_shark_data}
\alias{get_shark_data}
\title{Retrieve tabular data from SHARK}
\usage{
get_shark_data(
  tableView = "sharkweb_overview",
  headerLang = "internal_key",
  save_data = FALSE,
  file_path = NULL,
  delimiters = "point-tab",
  lineEnd = "win",
  encoding = "utf_8",
  dataTypes = c(),
  bounds = c(),
  fromYear = NULL,
  toYear = NULL,
  months = c(),
  parameters = c(),
  checkStatus = "",
  qualityFlags = c(),
  deliverers = c(),
  orderers = c(),
  projects = c(),
  datasets = c(),
  minSamplingDepth = "",
  maxSamplingDepth = "",
  redListedCategory = c(),
  taxonName = c(),
  stationName = c(),
  vattenDistrikt = c(),
  seaBasins = c(),
  counties = c(),
  municipalities = c(),
  waterCategories = c(),
  typOmraden = c(),
  helcomOspar = c(),
  seaAreas = c(),
  hideEmptyColumns = FALSE,
  row_limit = 10^7,
  prod = TRUE,
  utv = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{tableView}{Character. Specifies the columns of the table to retrieve. Options include:
\itemize{
\item \code{"sharkweb_overview"}: Overview table
\item \code{"sharkweb_all"}: All available columns
\item \code{"sharkdata_bacterioplankton"}: Bacterioplankton table
\item \code{"sharkdata_chlorophyll"}: Chlorophyll table
\item \code{"sharkdata_epibenthos"}: Epibenthos table
\item \code{"sharkdata_greyseal"}: Greyseal table
\item \code{"sharkdata_harbourporpoise"}: Harbour porpoise table
\item \code{"sharkdata_harbourseal"}: Harbour seal table
\item \code{"sharkdata_jellyfish"}: Jellyfish table
\item \code{"sharkdata_physicalchemical"}: Physical chemical table
\item \code{"sharkdata_physicalchemical_columns"}: Physical chemical table: column view
\item \code{"sharkdata_phytoplankton"}: Phytoplankton table
\item \code{"sharkdata_picoplankton"}: Picoplankton table
\item \code{"sharkdata_planktonbarcoding"}: Plankton barcoding table
\item \code{"sharkdata_primaryproduction"}: Primary production table
\item \code{"sharkdata_ringedseal"}: Ringed seal table
\item \code{"sharkdata_sealpathology"}: Seal pathology table
\item \code{"sharkdata_sedimentation"}: Sedimentation table
\item \code{"sharkdata_zoobenthos"}: Zoobenthos table
\item \code{"sharkdata_zooplankton"}: Zooplankton table
\item \code{"report_sum_year_param"}: Report sum per year and parameter
\item \code{"report_sum_year_param_taxon"}: Report sum per year, parameter and taxon
\item \code{"report_sampling_per_station"}: Report sampling per station
\item \code{"report_obs_taxon"}: Report observed taxa
\item \code{"report_stations"}: Report stations
\item \code{"report_taxon"}: Report taxa
}
Default is \code{"sharkweb_overview"}.}

\item{headerLang}{Character. Language option for column headers. Possible values:
\itemize{
\item \code{"sv"}: Swedish.
\item \code{"en"}: English.
\item \code{"short"}: Shortened version.
\item \code{"internal_key"}: Internal key (default).
}}

\item{save_data}{Logical. If \code{TRUE}, the downloaded data is written to \code{file_path} on disk.
If \code{FALSE} (default), data is temporarily written to a file and then read into memory as
a \code{data.frame}, after which the temporary file is deleted.}

\item{file_path}{Character. The file path where the data should be saved. Required if \code{save_data} is TRUE. Ignored if \code{save_data} is FALSE.}

\item{delimiters}{Character. Specifies the delimiter used to separate values in the file, if \code{save_data} is TRUE.
Options are \code{"point-tab"} (tab-separated) or \code{"point-semi"} (semicolon-separated).
Default is \code{"point-tab"}.}

\item{lineEnd}{Character. Defines the type of line endings in the file, if \code{save_data} is TRUE.
Options are \code{"win"} (Windows-style, \verb{\\r\\n}) or \code{"unix"} (Unix-style, \verb{\\n}).
Default is \code{"win"}.}

\item{encoding}{Character. Sets the file's text encoding, if \code{save_data} is TRUE.
Options are \code{"cp1252"}, \code{"utf_8"}, \code{"utf_16"}, or \code{"latin_1"}.
Default is \code{"utf_8"}.}

\item{dataTypes}{Character vector. Specifies data types to filter. Possible values include:
\itemize{
\item "Bacterioplankton"
\item "Chlorophyll"
\item "Epibenthos"
\item "Grey seal"
\item "Harbour Porpoise"
\item "Harbour seal"
\item "Jellyfish"
\item "Physical and Chemical"
\item "Phytoplankton"
\item "Picoplankton"
\item "PlanktonBarcoding"
\item "Primary production"
\item "Profile"
\item "Ringed seal"
\item "Seal pathology"
\item "Sedimentation"
\item "Zoobenthos"
\item "Zooplankton"
}}

\item{bounds}{A numeric vector of length 4 specifying the geographical search boundaries in decimal degrees,
formatted as \code{c(lon_min, lat_min, lon_max, lat_max)}, e.g., \code{c(11, 58, 12, 59)}. Default is \code{c()} to include all data.}

\item{fromYear}{Integer (optional). The starting year for data retrieval.
If set to \code{NULL} (default), the function will use the earliest available year in SHARK.}

\item{toYear}{Integer (optional). The ending year for data retrieval.
If set to \code{NULL} (default), the function will use the latest available year in SHARK.}

\item{months}{Integer vector. The months to retrieve data for, e.g., \code{c(4, 5, 6)} for April to June.}

\item{parameters}{Character vector. Optional parameters to filter the results by, such as \code{"Chlorophyll-a"}.}

\item{checkStatus}{Character string. Optional status check to filter results.}

\item{qualityFlags}{Character vector. Specifies the quality flags to filter the data. By default, all data are included, including those with the "B" flag (Bad).}

\item{deliverers}{Character vector. Specifies the data deliverers to filter by.}

\item{orderers}{Character vector. Orderers to filter by specific organizations or individuals.}

\item{projects}{Character vector. Projects to filter data by specific research or monitoring projects.}

\item{datasets}{Character vector. Datasets to filter data by specific datasets.}

\item{minSamplingDepth}{Numeric. Minimum sampling depth (in meters) to filter the data.}

\item{maxSamplingDepth}{Numeric. Maximum sampling depth (in meters) to filter the data.}

\item{redListedCategory}{Character vector. Red-listed taxa for conservation filtering.}

\item{taxonName}{Character vector. Optional vector of taxa names to filter by.}

\item{stationName}{Character vector. Station names to filter data by specific stations.}

\item{vattenDistrikt}{Character vector. Water district names to filter by Swedish water districts.}

\item{seaBasins}{Character vector. Sea basins to filter by.}

\item{counties}{Character vector. Counties to filter by specific administrative regions.}

\item{municipalities}{Character vector. Municipalities to filter by.}

\item{waterCategories}{Character vector. Water categories to filter by.}

\item{typOmraden}{Character vector. Type areas to filter by.}

\item{helcomOspar}{Character vector. HELCOM or OSPAR areas for regional filtering.}

\item{seaAreas}{Character vector. Sea area codes to filter by specific sea areas.}

\item{hideEmptyColumns}{Logical. Whether to hide empty columns. Default is FALSE.}

\item{row_limit}{Numeric. Specifies the maximum number of rows that can be retrieved in a single request.
If the requested data exceeds this limit, the function automatically downloads the data in yearly chunks
(ignored when \code{tableView = "report_*"}). The default value is 10 million rows.}

\item{prod}{Logical, whether to download from the production
(\code{TRUE}, default) or test (\code{FALSE}) SHARK server. Ignored if \code{utv} is \code{TRUE}.}

\item{utv}{Logical. Select UTV server when \code{TRUE}.}

\item{verbose}{Logical. Whether to display progress information. Default is TRUE.}
}
\value{
A \code{tibble} containing the retrieved SHARK data, parsed from
the API's delimited text response. Column types are inferred automatically.
}
\description{
The \code{get_shark_data()} function retrieves tabular data from the SHARK database hosted by SMHI. The function sends a POST request
to the SHARK API with customizable filters, including year, month, taxon name, water category, and more, and returns the
retrieved data as a structured \code{tibble}. To view available filter options, see \code{\link{get_shark_options}}.
}
\details{
This function sends a POST request to the SHARK API with the specified filters.
The API returns a delimited text file (e.g., tab- or semicolon-separated), which is
downloaded and read into R as a \code{tibble}. If the \code{row_limit} parameter is exceeded,
the data is retrieved in yearly chunks and combined into a single table. Adjusting the
\code{row_limit} parameter may be necessary when retrieving large datasets or detailed reports.
Note that making very large requests (e.g., retrieving the entire SHARK database)
can be extremely time- and memory-intensive.
}
\note{
For large queries spanning multiple years or including several data types,
retrieval can be time-consuming and memory-intensive. Consider filtering
by year, data type, or region for improved performance.
}
\examples{
\donttest{
  # Retrieve chlorophyll data from 2019 to 2020 for April to June
  shark_data <- get_shark_data(fromYear = 2019, toYear = 2020,
                               months = c(4, 5, 6), dataTypes = "Chlorophyll",
                               verbose = FALSE)
  print(shark_data)
}

}
\seealso{
\itemize{
\item \url{https://shark.smhi.se/en} – SHARK database portal
\item \code{\link[=get_shark_options]{get_shark_options()}} – Retrieve available filters
\item \code{\link[=get_shark_table_counts]{get_shark_table_counts()}} – Check table row counts before download
\item \code{\link[=get_shark_datasets]{get_shark_datasets()}} – To download datasets as zip-archives
}
}
