% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{translate_shark_datatype}
\alias{translate_shark_datatype}
\title{Translate SHARK4R datatype names}
\usage{
translate_shark_datatype(x)
}
\arguments{
\item{x}{Character vector of datatype names to translate}
}
\value{
Character vector of translated datatype names
}
\description{
Converts user-facing datatype names (e.g., "Grey seal") to internal SHARK4R names
(e.g., "GreySeal") based on \code{SHARK4R:::.type_lookup}. See available user-facing
datatypes in \code{get_shark_options()$dataTypes}.
}
\examples{
# Example strings
datatypes <- c("Grey seal", "Primary production", "Physical and Chemical")

# Basic translation
translate_shark_datatype(datatypes)

}
