% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getGv}
\alias{getGv}
\alias{getQueenGv}
\alias{getFathersGv}
\alias{getVirginQueensGv}
\alias{getWorkersGv}
\alias{getDronesGv}
\title{Access genetic values of individuals in a caste}
\usage{
getGv(x, caste = NULL, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getQueenGv(x, collapse = FALSE, simParamBee = NULL)

getFathersGv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getVirginQueensGv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getWorkersGv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getDronesGv(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, \code{\link[SIMplyBee]{Colony-class}}, or
\code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link[AlphaSimR]{Pop-class}},
and character when \code{x} is a \code{\link[SIMplyBee]{Colony-class}} or
 \code{\link[SIMplyBee]{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{collapse}{logical, if the return value should be a single matrix
with genetic values of all the individuals}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
vector of phenotype values when \code{x} is \code{\link[SIMplyBee]{Colony-class}}
  and list of vectors of genetic values when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}, named by colony id when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 function that returns genetic values of individuals
  in a caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenGv()}: Access genetic value of the queen

\item \code{getFathersGv()}: Access genetic values of fathers

\item \code{getVirginQueensGv()}: Access genetic values of virgin queens

\item \code{getWorkersGv()}: Access genetic values of workers

\item \code{getDronesGv()}: Access genetic values of drones

}}
\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(nQtlPerChr = 10, var = 1)
SP$addSnpChip(5)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

# Input is a population
getGv(x = getQueen(colony))
queens <- getQueen(apiary, collapse = TRUE)
getGv(queens)

# Input is a colony
getGv(colony, caste = "queen")
getQueenGv(colony)

getGv(colony, caste = "workers")
getWorkersGv(colony)
# Same aliases exist for all the castes!

# Get genetic values for all individuals
getGv(colony, caste = "all")
# Get all genetic values in a single matrix
getGv(colony, caste = "all", collapse = TRUE)

# Input is a MultiColony - same behaviour as for the Colony!
getGv(apiary, caste = "queen")
getQueenGv(apiary)

# Get the genetic values of all individuals either by colony or in a single matrix
getGv(apiary, caste = "all")
getGv(apiary, caste = "all", collapse = TRUE)
}
\seealso{
\code{\link[AlphaSimR]{gv}} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
