% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParamBee.R
\name{nVirginQueensPoisson}
\alias{nVirginQueensPoisson}
\alias{nVirginQueensTruncPoisson}
\alias{nVirginQueensColonyPhenotype}
\title{Sample a number of virgin queens}
\usage{
nVirginQueensPoisson(colony, n = 1, average = 10)

nVirginQueensTruncPoisson(colony, n = 1, average = 10, lowerLimit = 0)

nVirginQueensColonyPhenotype(
  colony,
  queenTrait = 1,
  workersTrait = 2,
  checkProduction = FALSE,
  lowerLimit = 0,
  simParamBee = NULL,
  ...
)
}
\arguments{
\item{colony}{\code{\link[SIMplyBee]{Colony-class}}}

\item{n}{integer, number of samples}

\item{average}{numeric, average number of virgin queens}

\item{lowerLimit}{numeric, returned numbers will be above this value}

\item{queenTrait}{numeric (column position) or character (column name), trait
that represents queen's effect on the colony phenotype (defined in
\code{\link[SIMplyBee]{SimParamBee}} - see examples); if \code{NULL} then this effect is 0}

\item{workersTrait}{numeric (column position) or character (column name), trait
that represents workers's effect on the colony phenotype (defined in
\code{\link[SIMplyBee]{SimParamBee}} - see examples); if \code{NULL} then this effect is 0}

\item{checkProduction}{logical, does the phenotype depend on the production
status of colony; if yes and production is not \code{TRUE}, the result is
above \code{lowerLimit}}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}

\item{...}{other arguments of \code{\link[SIMplyBee]{mapCasteToColonyPheno}}}
}
\value{
numeric, number of virgin queens
}
\description{
Sample a number of virgin queens - used when
  \code{nFathers = NULL} (see \code{\link[SIMplyBee]{SimParamBee}$nVirginQueens}).

  This is just an example. You can provide your own functions that satisfy
  your needs!
}
\details{
\code{nVirginQueensPoisson} samples from a Poisson distribution,
  which can return a value 0 (that would mean a colony will fail to raise a
  single virgin queen after the queen swarms or dies).

  \code{nVirginQueensTruncPoisson} samples from a truncated Poisson
  distribution (truncated at zero) to avoid failure.

  \code{nVirginQueensColonyPhenotype} returns a number (above
  \code{lowerLimit}) as a function of colony phenotype, say swarming
  tendency. Colony phenotype is provided by
  \code{\link[SIMplyBee]{mapCasteToColonyPheno}}. You need to set up traits
  influencing the colony phenotype and their parameters (mean and variances)
  via \code{\link[SIMplyBee]{SimParamBee}} (see examples).
}
\section{Functions}{
\itemize{
\item \code{nVirginQueensTruncPoisson()}: Sample a non-zero number of virgin queens

\item \code{nVirginQueensColonyPhenotype()}: Sample a non-zero number of virgin queens
based on colony's phenotype, say, swarming tendency

}}
\examples{
nVirginQueensPoisson()
nVirginQueensPoisson()
n <- nVirginQueensPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 30))
table(n)

nVirginQueensTruncPoisson()
nVirginQueensTruncPoisson()
n <- nVirginQueensTruncPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 30))
table(n)

# Example for nVirginQueensColonyPhenotype()
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
# Setting trait scale such that mean is 10 split into queen and workers effects
meanP <- c(5, 5 / SP$nWorkers)
# setup variances such that the total phenotype variance will match the mean
varA <- c(3 / 2, 3 / 2 / SP$nWorkers)
corA <- matrix(data = c(
  1.0, -0.5,
  -0.5, 1.0
), nrow = 2, byrow = TRUE)
varE <- c(7 / 2, 7 / 2 / SP$nWorkers)
varA / (varA + varE)
varP <- varA + varE
varP[1] + varP[2] * SP$nWorkers
SP$addTraitA(nQtlPerChr = 100, mean = meanP, var = varA, corA = corA)
SP$setVarE(varE = varE)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 50)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 2, nDrones = 15)
colony1 <- createColony(x = basePop[2])
colony2 <- createColony(x = basePop[3])
colony1 <- cross(colony1, drones = droneGroups[[1]])
colony2 <- cross(colony2, drones = droneGroups[[2]])
colony1 <- buildUp(colony1)
colony2 <- buildUp(colony2)
nVirginQueensColonyPhenotype(colony1)
nVirginQueensColonyPhenotype(colony2)
}
\seealso{
\code{\link[SIMplyBee]{SimParamBee}} field \code{nVirginQueens} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
