% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSVS_MI.R
\name{ssvs_mi}
\alias{ssvs_mi}
\title{Perform SSVS on Multiply Imputed Datasets}
\usage{
ssvs_mi(
  data,
  y,
  x,
  imp,
  imp_num = 5,
  interval = 0.9,
  continuous = TRUE,
  progress = FALSE
)
}
\arguments{
\item{data}{A dataframe containing the variables of interest, including an \code{.imp} column for imputation identifiers.}

\item{y}{The response variable (character string).}

\item{x}{A vector of predictor variable names.}

\item{imp}{The imputation variable.}

\item{imp_num}{The number of imputations to process (default is 5).}

\item{interval}{Confidence interval level for summary results (default is 0.9).}

\item{continuous}{Logical indicating if the response variable is continuous (default is TRUE).}

\item{progress}{Logical indicating whether to display progress (default is FALSE).}
}
\value{
An ssvs_mi object containing aggregated results across imputations that can be
used in \code{\link[=summary.ssvs_mi]{summary()}}.
}
\description{
This function performs Stochastic Search Variable Selection (SSVS) analysis on multiply imputed datasets
for a given set of predictors and a response variable. It supports continuous response variables and calculates
aggregated results across multiple imputations.
}
\examples{
\donttest{
data(imputed_mtcars)
outcome <- 'qsec'
predictors <- c('cyl', 'disp', 'hp', 'drat', 'wt', 'vs', 'am', 'gear', 'carb','mpg')
imputation <- '.imp'
agg_results <- ssvs_mi(data = imputed_mtcars, y = outcome, x = predictors, imp = imputation)
}
}
