% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Demography_functions.R
\name{Calculate_demography}
\alias{Calculate_demography}
\title{The base function for calculating demographic traits using a Leslie matrix method}
\usage{
Calculate_demography(
  data,
  AAFC = NULL,
  F. = 0,
  AALC = NULL,
  M.estimators = NULL
)
}
\arguments{
\item{data}{A multi-level list of the class `Demography.inputs` produced from the
`create_data_input` function and then manually completed.}

\item{AAFC}{Age-at-first-capture which can be specified by the user or automated in the
`Simulate_AAFC` function. Must be an integer age which can include zero to indicate
the availability of the population to capture from birth.}

\item{F.}{The instantaneous rate of fishing mortality 'F'. This will be applied to all
ages available to capture as defined by either the AALC or AAFC arguments.}

\item{AALC}{Age-at-last-capture which can be specified by the user or automated in the
`Simulate_AALC` function. Must be an integer age which can include zero.}

\item{M.estimators}{Any specific natural mortality estimators to be included in the analysis.
Only one will be used in each run which is randomly selected. In the simulation functions
these will be varied among simulations. Must be a single estimator or a vector of estimators.
These can include: "Pet.Wro","Jensen.mat","Chen.Yuan","Then_hoenig","Then_pauly", "
Jensen.mat","Charnov" or "Chen.Want". If none are specified then all applicable estimators
could be chosen.}
}
\value{
A list of parameters including: \describe{
\item{lambda}{The finite rate of population growth}
\item{R0}{The reproductive value of the population}
\item{G}{The generation length of the population}
\item{elast.fecund}{The mean elasticity of the fecundity elements}
\item{elast.juv.survival}{The mean elasticity of the juvenile survivoship elements}
\item{juv.ratio}{The ratio of fecundity to juvenile elasticities}
\item{adult.ratio}{The ratio of fecundity to adult elasticities}
\item{M.estimator}{The natural mortality estimator randomly used in this analysis}
}
}
\description{
Using provided life history estimates from various sources, a demographic
    analysis is performed using Leslie matrix methods. This function can be run as
    stand alond and will given the outputs of a stochastic matrix model given the provided
    life history parameters and their associated error. However, the main purpose of this
    function is to be used in other simulation functions provided in this package. In
    each use this function will calculate: \describe{
\item{lambda}{The finite rate of population growth}
\item{R0}{The reproductive value of the population}
\item{G}{The generation length of the population}
\item{elast.fecund}{The mean elasticity of the fecundity elements}
\item{elast.juv.survival}{The mean elasticity of the juvenile survivoship elements}
\item{juv.ratio}{The ratio of fecundity to juvenile elasticities}
\item{adult.ratio}{The ratio of fecundity to adult elasticities}
\item{M.estimator}{The natural mortality estimator randomly used in this analysis}
}
}
\examples{
# load Silky shark data produced by create_data_input()
# Type `?create_data_input()` for details
data("Silky_data")

# run a single Leslie Matrix analysis with random draws from biological data
# distributions. Use `Simulate_demography()` to run Monte Carlo Simulations
# using this function

Calculate_demography(Silky_data)

}
