% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{bin}
\alias{bin}
\title{Subfunction of bin_metadata() for expression/positional binning}
\usage{
bin(
  dat,
  md,
  k,
  pos = TRUE,
  pos_k = 55,
  ex_k = 1,
  hc_function = "ward.D2",
  plot_directory
)
}
\arguments{
\item{dat}{data.table of smoothed relative expression intensities}

\item{md}{data.table of metadata of each bead}

\item{k}{number of malignant bins to set}

\item{pos}{TRUE if doing spatial and expressional binning, FALSE if just expressional binning}

\item{pos_k}{positional weight}

\item{ex_k}{expressional weight}

\item{hc_function}{hierarchical clustering function}

\item{plot_directory}{output plot directory path}
}
\value{
A data.table of bead metadata combined with bin designations
}
\description{
This function computes a pseudospatial distance between beads that combines spatial distance and distance from the expression space, then using the silhouette score and hierarchical clustering, segregates beads into bins
}
