% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{find_cluster_markers}
\alias{find_cluster_markers}
\title{Find and plot top n DEGs per cluster}
\usage{
find_cluster_markers(
  so_clone,
  type,
  logfc.threshold = 0.2,
  min.pct = 0,
  only.pos = TRUE,
  n_markers = 5,
  value = "log2_expr",
  text_size = 16,
  title_size = 18,
  legend_size_pt = 4,
  p_val_thresh = 0.05,
  bin = TRUE,
  plot_directory = None
)
}
\arguments{
\item{so_clone}{seurat object with 'clone' (SlideCNA-designated cluster) and bin annotations}

\item{type}{character string that is 'all' if using malignant and normal clusters and 'malig'
if just using malignant clusters}

\item{logfc.threshold}{numeric float that is seurat parameter,
representing the minimum log2 fold change for DEGs to be significant}

\item{min.pct}{numeric Seurat function parameter}

\item{only.pos}{TRUE if only using DEGs with positive log2 fold change}

\item{n_markers}{integer of number of top DEGs to plot/use}

\item{value}{expression value of DEGs;  one of ("log2_expr", "avg_expr", and "avg_log2FC") for log2-normalized aerage epxression, average expression, or log2 fold change}

\item{text_size}{Ggplot2 text size}

\item{title_size}{Ggplot2 title size}

\item{legend_size_pt}{Ggplot2 legend_size_pt}

\item{p_val_thresh}{value for p value cutoff for DEGs}

\item{bin}{TRUE if using binned beads}

\item{plot_directory}{output plot directory path}
}
\value{
A list object with cluster marker information
markers_clone = data.table of all cluster markers
top_markers_clone = data.table of just top cluster markers
top_clone_vis = data.frame formatted for plot visualization of top cluster markers
}
\description{
This function uses Seurat's marker finding capability to find DEGs of each cluster
}
