% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mu_solver.R
\name{mu_solver}
\alias{mu_solver}
\title{Mu Solver}
\usage{
mu_solver(d, mu, v, EQ, dim, x, nk, p1, p2, delta)
}
\arguments{
\item{d}{- The current condition.}

\item{mu}{- A matrix of regularized mean values.}

\item{v}{- Relationship matrix, describing relationship between d-1 and d.}

\item{EQ}{- Equality matrix specifying the number of following terms to
which mu_d is equal.}

\item{dim}{- Total dimensions.}

\item{x}{- Matrix of mean values.}

\item{nk}{- Vector with the number of samples in each condition for this
cluster.}

\item{p1}{- Penalties on mean size.}

\item{p2}{- Penalties on mean difference.}

\item{delta}{Small term to ensure existance of solution.}
}
\value{
A matrix containing the regularized cluster means for each
dimension.
}
\description{
Calculates the regularized center values for a cluster. This function
 runs inside \code{sparse_mdc}.
}
