% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_in_par.R
\name{get_param_info}
\alias{get_param_info}
\title{Finding parameters information using partial search words}
\usage{
get_param_info(param = NULL, keyword = NULL, stics_version = "latest")
}
\arguments{
\item{param}{Vector of parameter names (or partial names). Optional, if not
provided, the function returns information for all parameters}

\item{keyword}{Optional, strings or a vector of to be used for searching
in parameters names and definition}

\item{stics_version}{Name of the STICS version. Optional, can be used
to search parameters information relative to a specific STICS version.
By default the latest version returned by \code{get_stics_versions_compat()}
is used.}
}
\value{
A data.frame with information about parameter(s) with columns
\code{name},\code{file},\code{min},\code{max}, \code{definition}
}
\description{
Helper function that returns names and descriptions of
STICS input parameters from a partial name and/or descriptive keywords.
}
\details{
The function understand \code{\link[base]{regex}} as input.
}
\examples{

# Find by parameter name (fuzzy search):
SticsRFiles::get_param_info("alb")
SticsRFiles::get_param_info("alb[e]?")

# Find by keyword (fuzzy search in parameter name and description):
SticsRFiles::get_param_info(keyword = "bdil")

# Find for a particular version:
SticsRFiles::get_param_info("alb", stics_version = "V9.0")

}
