% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathwayCount.R
\name{pathway_count}
\alias{pathway_count}
\title{Count Genes Present in Pathways Above a Threshold}
\usage{
pathway_count(GO, count_threshold, enrich_data)
}
\arguments{
\item{GO}{A character vector of gene symbols.}

\item{count_threshold}{An integer specifying the count threshold for selecting pathways.}

\item{enrich_data}{A data frame containing pathway enrichment analysis results.}
}
\value{
A data frame with columns "Symble" (gene symbol), "Description" (pathway description), and "Exists" (1 if gene is present, 0 otherwise).
}
\description{
This function filters pathways that meet a count threshold and then counts the presence of specified genes in those pathways.
}
\examples{
# Simulated gene list
GO <- c("Gene1", "Gene2", "Gene3", "Gene4", "Gene5")
# Simulated enrichment analysis data
enrich_data <- data.frame(
  ID = c("GO:0001", "GO:0002", "GO:0003"),
  Description = c("Pathway A", "Pathway B", "Pathway C"),
  Count = c(10, 4, 6),
  geneID = c("Gene1/Gene2/Gene3", "Gene4/Gene5", "Gene2/Gene6/Gene7")
)

# Example usage
count_threshold <- 5
result_df <- pathway_count(GO, count_threshold, enrich_data)

}
