% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\docType{data}
\name{stat_xspline}
\alias{stat_xspline}
\alias{StatXspline}
\title{X-spline Statistic for ggplot2 (adapted from ggalt)}
\usage{
stat_xspline(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  spline_shape = -0.25,
  open = TRUE,
  rep_ends = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes()} or \code{aes_()}.}

\item{data}{The data to be displayed in this layer.}

\item{geom}{The geometric object to use display the data.}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than combining with them.}

\item{spline_shape}{Numeric value controlling the shape of the spline. Default is -0.25.}

\item{open}{Logical. If \code{TRUE}, the spline is open; if \code{FALSE}, it is closed.}

\item{rep_ends}{Logical. If \code{TRUE}, the end points are repeated.}

\item{...}{Other arguments passed on to \code{layer()}.}
}
\value{
A ggplot2 layer that can be added to a plot.
}
\description{
This statistic adds an X-spline interpolation to your ggplot2 plots, allowing for smooth curves through a series of points.
The implementation is adapted from the \code{stat_xspline} function in the \pkg{ggalt} package (GPL-3), originally authored by Bob Rudis.
}
\section{License and Attribution}{

This code is adapted from the \pkg{ggalt} package (\url{https://github.com/hrbrmstr/ggalt}), which is licensed under GPL-3.
Original author: Bob Rudis (\email{bob@rud.is}).
}

\section{Computed variables}{

\itemize{
  \item{x} X coordinates of the spline.
  \item{y} Y coordinates of the spline.
}
}

\examples{
\donttest{
library(ggplot2)
df <- data.frame(x = 1:10, y = cumsum(rnorm(10)))
ggplot(df, aes(x, y)) +
  geom_point() +
  stat_xspline(spline_shape = 0.5)
}

}
\keyword{datasets}
