% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combineVC}
\alias{combineVC}
\title{Combine Variance Components and Adjust Degrees of Freedom.}
\usage{
combineVC(obj, comb = NULL)
}
\arguments{
\item{obj}{(object) of class 'VCA', either fitted by ANOVA
or REML}

\item{comb}{(character) strings refering to variance components
the shall be combined}
}
\value{
(object) of class 'VCA' with an updated 'aov.tab' element
}
\description{
Combining variance estimates of multiple terms, mostly, effects
of a full model containing a single source of variability. One
example would be a precision experiment where three reagentlots
are measured on one instrument in parallel, i.e. on the same days.
As days are not independent of each other one needs the mean effect
'day' but as there is also interaction between reagentlot and day
an interaction term 'lot:day' is needed. As the interaction term
cannot be interpreted in a straight forward manner, effects 'day'
and 'lot:day' need to be combined accounting for day-to-day
variability.
}
\examples{
\donttest{
# assume interactions lot:day
set.seed(323)
dat <- data.frame(
	 lot = rep(1:3, c(25, 25, 25)),
	 day = rep(rep(1:5, rep(5,5)), 3),
  res = 25)
# mean value of measurements is 25
# add variance component 'lot' (5\% CV)
dat$res <- dat$res + rep(rnorm(3,,1.25), c(25, 25, 25))
# add variance component 'day' (4\% CV)
dat$res <- dat$res + rep(rep(rnorm(5,,1), rep(5,5)), 3)
# add interaction variance 'lot:day' (4\% CV)
dat$res <- dat$res + rep(rnorm(15,,1), rep(5, 15))
# add repeatability variance(2\% CV)
dat$res <- dat$res + rnorm(75,,0.5)

# data analysis
# 3 lots were measured in parallel on the same 5 days
# using main effects 'lot' and 'day' shifts interaction
# variability 'lot:day' into 'error'
fitW <- anovaVCA(res~lot+day, dat)
fitW
# use saturated model and combine variance components
# 'day' and 'lot:day'
fit0 <- anovaVCA(res~lot*day, dat)
fit1 <- VCA:::combineVC(fit0, c("day", "lot:day"))
fit0
fit1
fitW
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
