% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictCounts.R
\name{predictCounts}
\alias{predictCounts}
\alias{predictCounts.familyWALScount}
\title{Internal methods: Predict probability for counts}
\usage{
predictCounts(x, ...)

\method{predictCounts}{familyWALScount}(x, yUnique, rowNames, eta, ...)
}
\arguments{
\item{x}{object of class \code{"\link[WALS]{familyWALScount}"}.}

\item{...}{Further parameters passed to \code{density()} function in
\code{family}.}

\item{yUnique}{vector. The counts (larger or equal to zero) which to predict
probabilities for.}

\item{rowNames}{vector. The names of the observations.}

\item{eta}{vector. The fitted linear link \eqn{\hat{\eta}} of the model.}
}
\value{
Returns a matrix of dimension \code{length(eta)} times
\code{length{yUnique}} with the predicted probabilities of the counts given
in \code{yUnique} for every observation in \code{eta}.
}
\description{
Predicts the probability of counts given a family object of class
\code{"\link{familyWALScount}"}. Only works for count data models.
}
\details{
\code{"\link{familyWALScount}"} objects are used in the fitting methods
\code{\link[WALS]{walsNB}}, \code{\link[WALS]{walsNBmatrix}},
\code{\link[WALS]{walsGLM}} or \code{\link[WALS]{walsGLMmatrix}}. For the
latter two, only the family \code{\link[WALS]{poissonWALS}} is currently
supported.

\code{predictCounts()} is not available for objects of any class except for
\code{"\link{familyWALScount}"}.

The \code{predictCounts.familyWALScount()} method is a modified version of the
\code{predict.hurdle()} method from the \code{countreg} package
version 0.2-1 (2023-06-13) \insertCite{countreg,countreghurdle}{WALS} using the argument
\code{type = "prob"}.
}
\references{
\insertAllCited{}
}
