% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsGLM.R
\name{walsGLM}
\alias{walsGLM}
\alias{walsGLM.formula}
\alias{walsGLM.matrix}
\alias{walsGLMmatrix}
\alias{walsGLM.default}
\title{Weighted Average Least Squares for Generalized Linear Models}
\usage{
walsGLM(x, ...)

\method{walsGLM}{formula}(
  formula,
  family,
  data,
  subset = NULL,
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  prior = weibull(),
  controlInitGLM = controlGLM(),
  model = TRUE,
  keepY = TRUE,
  keepX = FALSE,
  iterate = FALSE,
  tol = 1e-06,
  maxIt = 50,
  nIt = NULL,
  verbose = FALSE,
  ...
)

\method{walsGLM}{matrix}(
  x,
  x2,
  y,
  family,
  subset = NULL,
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  prior = weibull(),
  controlInitGLM = controlGLM(),
  keepY = TRUE,
  keepX = FALSE,
  iterate = FALSE,
  tol = 1e-06,
  maxIt = 50,
  nIt = NULL,
  verbose = FALSE,
  ...
)

\method{walsGLM}{default}(x, ...)
}
\arguments{
\item{x}{Design matrix of focus regressors. Usually includes a constant
(column full of 1s) and can be generated using \code{\link[stats]{model.matrix}}.}

\item{...}{Arguments for workhorse \code{\link[WALS]{walsGLMfit}}.}

\item{formula}{an object of class \code{"\link[Formula]{Formula}"}
(or one that can be coerced to that class, e.g. \code{"\link[stats]{formula}"}):
a symbolic description of the model to be fitted.
The details of model specification are given under ‘Details’.}

\item{family}{Object of class \code{"\link[WALS]{familyWALS}"}.}

\item{data}{an optional data frame, list or environment
(or object coercible by \code{\link[base]{as.data.frame}} to a data frame)
containing the variables in the model. If not found in \code{data}, the variables
are taken from \code{environment(formula)}, typically the environment which
the function is called from.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{\strong{not implemented yet.}}

\item{weights}{\strong{not implemented yet.}}

\item{offset}{\strong{not implemented yet.}}

\item{prior}{Object of class \code{"\link[WALS]{familyPrior}"}. For example
\code{\link[WALS]{weibull}} or \code{\link[WALS]{laplace}}.}

\item{controlInitGLM}{Controls estimation of starting values for one-step ML,
see \code{\link[WALS]{controlGLM}}.}

\item{model}{if \code{TRUE} (default), then the model.frame is stored in
the return.}

\item{keepY}{if \code{TRUE} (default), then the response is stored in
the return.}

\item{keepX}{if \code{TRUE}, then the model matrices are stored in the return.
the return.}

\item{iterate}{if \code{TRUE} then the WALS algorithm is iterated using the previous
estimates as starting values.}

\item{tol}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}.
If the Euclidean distance between the previous and current coefficient vector
divided by the square root of the length of the vector falls below \code{tol},
then the algorithm stops. See \code{\link[WALS]{walsGLMfitIterate}} for more details.}

\item{maxIt}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}. Aborts
iterative fitting when number of iterations exceed \code{maxIt}.}

\item{nIt}{Only used if \code{iterate = TRUE}. If this is specified, then
\code{tol} is ignored and the algorithm iterates \code{nIt} times. This option
should not be used unless the user has a specific reason to run the algorithm
\code{nIt} times, e.g. for replication purposes.}

\item{verbose}{If \code{verbose = TRUE}, then it prints the iteration process
(only relevant if \code{iterate = TRUE}).}

\item{x2}{Design matrix of auxiliary regressors. Usually does not include
a constant column and can also be generated using \code{\link[stats]{model.matrix}}.}

\item{y}{Response as vector.}
}
\value{
\code{walsGLM.formula()} returns an object of class \code{"walsGLM"}
which inherits from \code{"\link[WALS]{wals}"}. This is a list that contains
all elements returned from \code{\link[WALS]{walsGLMfitIterate}} and additionally
\item{cl}{Call of the function.}
\item{formula}{\code{formula} used.}
\item{terms}{List containing the model terms of the focus and auxiliary
regressors separately, as well as for the full model.}
\item{levels}{List containing the levels of the focus and auxiliary
regressors separately, as well as for the full model.}
\item{contrasts}{List containing the contrasts of the design matrices of
focus and auxiliary regressors.}
\item{model}{If \code{model = TRUE}, contains the model frame.}

See returns of \code{\link[WALS]{walsGLMfit}} and \code{\link[WALS]{walsGLMfitIterate}}
for more details.

\code{walsGLM.matrix()} returns an object of class
\code{"walsGLMmatrix"}, which inherits from \code{"walsGLM"}, \code{"walsMatrix"}
and \code{"wals"}. This is a list that contains all elements returned from
\code{\link[WALS]{walsGLMfitIterate}} and additionally the call in \code{cl}.

\code{walsGLM.default()} raises an error if \code{x} is not an object
of class \code{"matrix"} or a class that extends \code{"matrix"}. Otherwise
returns an object of class \code{"walsGLMmatrix"}. See above for more details.
}
\description{
Performs model averaging of generalized linear models (GLMs) using the
Weighted-Average Least Squares method described in \insertCite{deluca2018glm;textual}{WALS}.
}
\details{
Computes WALS estimates when focus regressors (X1) are present in all
submodels and model averaging takes place over the auxiliary regressors (X2).

Formulas typically contain two parts, i.e. they are of the form
"\code{y ~ X11 + X12 | X21 + X22}", where the variables before "\code{|}" are
the focus regressors (includes a constant by default) and the ones after
"\code{|}" are the auxiliary regressors. If only a one-part formula is
specified, then all regressors are considered as auxiliary regressors and only
a constant is employed as focus regressor, i.e.
"\code{y ~ X1 + X2}" is equivalent to "\code{y ~ 1 | X1 + X2}".

\strong{WARNING:} Interactions in formula do work work properly yet.
It is recommended to manually create the interactions beforehand and then
to insert them as 'linear terms' in the formula.

\code{walsGLM.default()} raises an error if \code{x} is not an object of class
\code{"matrix"} or a class that extends \code{"matrix"}. Otherwise it calls
\code{walsGLM.matrix()}. It is a modified version of \code{glmboost.default}
from the \code{mboost} package version 2.9-8 (2023-09-06) \insertCite{mboost}{WALS}.
}
\examples{
data("HMDA", package = "AER")
fitBinomial <- walsGLM(deny ~ pirat + hirat + lvrat + chist + mhist + phist |
                       selfemp + afam, data = HMDA, family = binomialWALS(),
                       prior = weibull())
summary(fitBinomial)

data("NMES1988", package = "AER")
fitPoisson <- walsGLM(emergency ~ health + chronic + age + gender |
                      I((age^2)/10) + married + region, data = NMES1988,
                      family = poissonWALS(), prior = laplace())
summary(fitPoisson)

## Example for walsGLM.matrix()
data("HMDA", package = "AER")
X <- model.matrix(deny ~ pirat + hirat + lvrat + chist + mhist + phist + selfemp + afam,
                  data = HMDA)
X1 <- X[,c("(Intercept)", "pirat", "hirat", "lvrat", "chist2", "chist3",
        "chist4", "chist5", "chist6", "mhist2", "mhist3", "mhist4", "phistyes")]
X2 <- X[,c("selfempyes", "afamyes")]
y <- HMDA$deny
fit <- walsGLM(X1, X2, y, family = binomialWALS(), prior = weibull())
summary(fit)

}
\references{
\insertAllCited{}
}
