% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zeta.R
\name{Zeta}
\alias{Zeta}
\title{Calculation of zeta and weighted zeta score.}
\usage{
Zeta(ZscoreVal, ZseqList, SVMcurve = NULL, SVM = FALSE)
}
\arguments{
\item{ZscoreVal}{A matrix of Z-scores where rows represent genes and columns represent readouts/conditions. This is typically the output from the Zscore() function.}

\item{ZseqList}{A list containing two vectors: 'Zseq_D' (decrease direction thresholds) and 'Zseq_I' (increase direction thresholds). These define the Z-score bins for calculating event coverage.}

\item{SVMcurve}{Optional. A matrix containing SVM curve data for decrease and increase directions. Required only when SVM=TRUE. The matrix should have 4 columns: Z-score and coverage for decrease direction (columns 1-2), and Z-score and coverage for increase direction (columns 3-4).}

\item{SVM}{Logical. Whether to use SVM curves for background correction. Default is FALSE. When TRUE, the function subtracts SVM-predicted background from the event coverage before calculating zeta scores.}
}
\value{
A data frame with two columns:
  \item{Zeta_D}{Zeta score for decrease direction (exon skipping events)}
  \item{Zeta_I}{Zeta score for increase direction (exon inclusion events)}

Each row corresponds to a gene, and the zeta scores represent the cumulative regulatory effect across all Z-score thresholds.
}
\description{
This function calculates zeta scores for genes based on their Z-score profiles across different thresholds. The zeta score quantifies the regulatory effect of gene knockdown on alternative splicing events by measuring the area under the curve of event coverage across Z-score thresholds.
}
\details{
The function calculates zeta scores as follows:
\enumerate{
  \item For each Z-score threshold, calculates the proportion of readouts that exceed (increase) or fall below (decrease) the threshold
  \item Computes the area under the event coverage curve using trapezoidal integration
  \item If SVM=TRUE, subtracts SVM-predicted background coverage before area calculation
  \item Returns separate scores for decrease (Zeta_D) and increase (Zeta_I) directions
}

Higher zeta scores indicate stronger regulatory effects on alternative splicing.
}
\examples{
data(ZseqList)
data(SVMcurve)
data(countMat)
data(negGene)
ZscoreVal <- Zscore(countMat, negGene)
zetaData <- Zeta(ZscoreVal, ZseqList, SVM=FALSE)

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{ZetaSuite}
\keyword{alternative}
\keyword{score}
\keyword{splicing}
\keyword{zeta}
