% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_measures.R
\docType{data}
\name{diversity_measures}
\alias{diversity_measures}
\alias{alpha_diversities}
\alias{beta_diversities}
\alias{phylogenetic_alpha_diversities}
\alias{phylogenetic_beta_diversities}
\title{Diversity measures implemented}
\format{Four objects of class \code{character}.}
\usage{
alpha_diversities

beta_diversities

phylogenetic_alpha_diversities

phylogenetic_beta_diversities
}
\description{
The diversity functions offered in \code{abdiv} are organized based on the
function signature.
}
\details{
The following character vectors are provided:
\describe{
  \item{\code{alpha_diversities}}{
    All non-phylogenetic alpha diversity measures. These functions take a
    single numeric vector as an argument.}
  \item{\code{beta_diversities}}{
    All non-phylogenetic beta diversity measures. These functions take two
    numeric vectors as arguments.}
  \item{\code{phylogenetic_alpha_diversities}}{
    There is only one phylogenetic alpha diversity measure implemented, but
    we use the plural to be consistent with the other vectors. This function
    takes a numeric vector, a phylogenetic tree object, and optionally a
    character vector of species labels.}
  \item{\code{phylogenetic_beta_diversities}}{
    Phylogenetic measures of beta diversity. These functions take two
    numeric vectors, a phylogenetic tree object, and optionally a
    character vector of species labels.}
}
}
\keyword{datasets}
