% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesGlassoBlock.R
\name{BayesGlassoBlock}
\alias{BayesGlassoBlock}
\title{Adaptive Bayesian graphical lasso MCMC sampler}
\usage{
BayesGlassoBlock(X, burnin = 1000, nmc = 2000)
}
\arguments{
\item{X}{Numeric matrix.}

\item{burnin}{An integer specifying the number of burn-in iterations.}

\item{nmc}{An integer specifying the number of MCMC samples.}
}
\value{
list containing:
\describe{
\item{Sig}{A \code{p} by \code{p} by \code{nmc} array of saved posterior samples of covariance matrices.}
\item{Omega}{A \code{p} by \code{p} by nmc array of saved posterior samples of precision matrices.}
\item{Lambda}{A 1 by \code{nmc} vector of saved posterior samples of lambda values.}
}
}
\description{
A Bayesian adaptive graphical lasso  data-augmented block Gibbs sampler. The sampler is adapted from the MATLAB routines used in Wang (2012).
}
\examples{
\donttest{
# Generate true covariance matrix:
p             <- 10
n             <- 50
SigTrue       <- pracma::Toeplitz(c(0.7^rep(1:p-1)))
CTrue         <- pracma::inv(SigTrue)
# Generate expected value vector:
mu            <- rep(0,p)
# Generate multivariate normal distribution:
set.seed(123)
X             <- MASS::mvrnorm(n,mu=mu,Sigma=SigTrue)
abglasso_post <- BayesGlassoBlock(X,burnin = 1000,nmc = 2000)
}
}
\references{
Wang, H. (2012). Bayesian graphical lasso models and efficient
posterior computation. \emph{Bayesian Analysis, 7}(4). \doi{10.1214/12-BA729}.
}
