% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entry_info.R
\name{adf_entry_info}
\alias{adf_entry_info}
\alias{adf_entry_info.adf_device}
\alias{adf_entry_info.adf_device.virtual_path}
\alias{adf_entry_info.adf_device.character}
\alias{adf_entry_info.virtual_path}
\alias{adf_entry_info.adf_file_con}
\title{Retrieve information from entry headers on virtual ADF devices}
\usage{
adf_entry_info(x, path, ...)

\method{adf_entry_info}{adf_device}(x, path, ...)

\method{adf_entry_info.adf_device}{virtual_path}(x, path, ...)

\method{adf_entry_info.adf_device}{character}(x, path, ...)

\method{adf_entry_info}{virtual_path}(x, path, ...)

\method{adf_entry_info}{adf_file_con}(x, path, ...)
}
\arguments{
\item{x}{Either a virtual device or virtual path.}

\item{path}{A \code{\link[=virtual_path]{virtual_path()}} pointing to the targeted entry (file or directory). Should
be omitted when \code{x} is already a virtual path.}

\item{...}{Ignored}
}
\value{
Returns a \code{list} of named \code{list}s of entry properties.
Elements included in the named \code{list}
depend on the type of entry (root, directory or file).
}
\description{
Retrieve information from entry (file and directory) headers on virtual ADF devices.
Get information like entry name, modification date, file size etc.
}
\examples{
## First setup a connection to a virtual device
my_device <- demo_adf()

adf_entry_info(my_device, "DF0:")
adf_entry_info(my_device, "s")
adf_entry_info(my_device, "s/startup-sequence")

close(my_device)
}
\author{
Pepijn de Vries
}
