% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hicClust.R
\name{hicClust}
\alias{hicClust}
\title{Adjacency-constrained Clustering of Hi-C contact maps}
\usage{
hicClust(x, h = NULL, log = FALSE, ...)
}
\arguments{
\item{x}{either: 1. A pxp contact sparse or dense matrix (classes matrix,
Matrix, dscMatrix, dgTMatrix, dgCMatrix, dgeMatrix). Its entries are the 
number of counts of physical interactions observed between all pairs of loci. 
2. An object of class HiTC::HTCexp. The corresponding Hi-C data is stored as 
a Matrix::dsCMatrix object in the intdata slot. 3. A text file path with one 
line per pair of loci for which an interaction has been observed (in the 
format: locus1<tab>locus2<tab>signal) or a matrix or data frame with similar
data (3 columns).}

\item{h}{band width. If not provided, \code{h} is set to default value `p-1`.}

\item{log}{logical. Whether to log-transform the count data. Default to 
\code{FALSE}.}

\item{\dots}{further arguments to be passed to \code{\link{read.table}} 
function when \code{x} is a text file name. If not provided, the text file 
is supposed to be separated by tabulations, with no header.}
}
\value{
An object of class \code{\link{chac}}.
}
\description{
Adjacency-constrained hierarchical agglomerative clustering of Hi-C contact
maps
}
\details{
Adjacency-constrained hierarchical agglomerative clustering (HAC) is HAC in
which each observation is associated to a position, and the clustering is 
constrained so as only adjacent clusters are merged. Genomic regions (loci)
are clustered according to information provided by high-throughput
conformation capture data (Hi-C).
}
\examples{
# input as HiTC::HTCexp object
\dontrun{
if (require("HiTC", quietly = TRUE)) {
  load(system.file("extdata", "hic_imr90_40_XX.rda", package = "adjclust"))
  res1 <- hicClust(hic_imr90_40_XX)
}
}

# input as Matrix::dsCMatrix contact map
\dontrun{
mat <- HiTC::intdata(hic_imr90_40_XX) 
res2 <- hicClust(mat)
}

# input as text file
res3 <- hicClust(system.file("extdata", "sample.txt", package = "adjclust"))

}
\references{
Ambroise C., Dehman A., Neuvial P., Rigaill G., and Vialaneix N
  (2019). \emph{Adjacency-constrained hierarchical clustering of a band
  similarity matrix with application to genomics}, Algorithms for Molecular
  Biology 14(22)"

Servant N. \emph{et al} (2012). \emph{HiTC : Exploration of 
  High-Throughput 'C' experiments. Bioinformatics}.
}
\seealso{
\code{\link{adjClust}}
}
