% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_substitutions.R
\name{write_substitutions}
\alias{write_substitutions}
\title{Generate and export a list of substitutions}
\usage{
write_substitutions(
  file,
  alignment,
  poi,
  sub,
  mode = c("recycle", "expand_grid")
)
}
\arguments{
\item{file}{A file path.}

\item{alignment}{A character matrix or an alignment object obtained with
\code{\link[=read_alignment]{read_alignment()}}. Rows are expected to be sequences of single characters
(protein residues), and columns the alignment positions. The first row must
be the reference sequence, i.e. the sequence whose substitutions will be
evaluated against.}

\item{poi}{A whole number indicating the position of interest (POI).}

\item{sub}{A character vector of protein residue substitutions to be
classified. The amino acids must be provided as one-letter symbols.}

\item{mode}{If both \code{poi} and \code{sub} contain more than one element, \code{mode}
specifies how these two inputs are combined. If \code{mode = 'recycle'} the
shortest vector is recycled to match the length of the longest. If \code{mode = 'expand_grid'}, all combinations between elements of \code{poi} and \code{sub} are
combined.}
}
\value{
This function is run for its side effect of writing a file. But it
returns the file path passed in \code{file}.
}
\description{
This function exports to a file a list of residue substitutions. The format
used will be  the same one as requested by the web version of
\href{http://agvgd.hci.utah.edu/help.php}{Align-GVGD}.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
write_substitutions(file = "ex01.csv",
                    alignment = read_alignment("ATM"),
                    poi = 20:25,
                    sub = amino_acids())
cat(readLines("ex01.csv"), sep = "\n")

write_substitutions(file = "ex02.csv",
                    alignment = read_alignment("ATM"),
                    poi = 20:21,
                    sub = amino_acids(),
                    mode = 'expand_grid')
cat(readLines("ex02.csv"), sep = "\n")
\dontshow{
setwd(.old_wd)
}
}
