% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_plot.R
\name{influence_plot}
\alias{influence_plot}
\title{Influence plots}
\usage{
influence_plot(
  model,
  rtype = c("studentized", "standardized"),
  criterion = c("cooks", "dffits"),
  id_n = 3,
  add_reference = TRUE,
  alpha = 0.05,
  size = c(1, 4.8),
  ...,
  text_arglist = list(),
  abline_arglist = list(),
  extendrange_f = 0.08
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{rtype}{The residual type to plot on the y-axis. The
default is \code{"studentized"}. The other option is
\code{"standardized"}.}

\item{criterion}{The criterion that decides the size of
the points. The default is \code{"cooks"}. The other
option is \code{"dffits"}.}

\item{id_n}{The number of points to identify with labels
with respect to largest absolute criterion. The default
is \code{3} labels.}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}.}

\item{alpha}{The default quantile used for the horizontal
reference lines. The default is 0.05. See Details.}

\item{size}{A numeric vector of length 2 that provides
guidelines for the size of the points.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
\code{influence_plot} creates an influence plot for a
fitted \code{lm} object. The y-axis is either the
studentized (the default) or standardized residuals
versus the leverage values for each observation. The size
of the point associated with each observation is
proportional to the value of the Cook's distance (the
default) or the DFFITS statistic for the observation.
\cr\cr Details about the different types of residuals are
discussed in the \code{\link[api2lm]{get_residuals}}
function.
}
\details{
The range of the \code{criterion} statistic is mapped to
\code{cex_pt = size[2]^2 - size[1]^2} and then the size
of the points is \code{sqrt(cex_pt)}.

If \code{add_reference} is \code{TRUE}, then horizontal
reference lines are added at the \eqn{\alpha/2} and
\eqn{1-\alpha/2} quantiles of a t distribution with
degrees of freedom given by
\code{stats::df.residual(model)}.

If \code{add_reference} is \code{TRUE}, then vertical
reference lines are added at \eqn{2p/n} and \eqn{0.5}
where \eqn{p=}\code{length(stats::coef(model))} and
\eqn{n=}\code{stats::nobs(model)}.

The vertical position of the reference lines can be
customized by setting the \code{h} argument of
\code{abline_arglist}. The horizontal position of the
reference lines can be customized by setting the \code{v}
argument of \code{abline_arglist}.
}
\examples{
lmod <- lm(murder ~ hs_grad + urban + poverty + single,
           data = crime2009)
# studentized residuals vs leverage
influence_plot(lmod, id_n = 3)
# standardized residuals vs leverage
influence_plot(lmod, rtype = "stan")
# similar plot from plot.lm
plot(lmod, which = 5)
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[graphics]{abline}},
  \code{\link[stats]{rstandard}},
  \code{\link[stats]{rstudent}},
  \code{\link[stats]{hatvalues}}
  \code{\link[stats]{cooks.distance}},
  \code{\link[stats]{dffits}}
}
\author{
Joshua French
}
