
<!-- README.md is generated from README.Rmd. Please edit that file -->

# apisensr <img src="man/figures/logo.png" align="right" width="240" style="float:right; with:240px;"/>

<!-- badges: start -->

[![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/apisensr)](https://cran.r-project.org/package=apisensr)
[![R CMD
check](https://ci.codeberg.org/api/badges/14600/status.svg)](https://ci.codeberg.org/repos/14600)
[![](https://img.shields.io/badge/doi-10.32614/CRAN.package.apisensr-blue.svg)](https://doi.org/10.32614/CRAN.package.apisensr)
[![Project Status: Active – The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![Total CRAN
downloads](https://cranlogs.r-pkg.org/badges/grand-total/apisensr)](https://cran.r-project.org/package=apisensr)

<!-- badges: end -->

**apisensr** provides an interactive web app for the R package
[**episensr**](https://cran.r-project.org/package=episensr). The R
package **episensr** allows to do basic sensitivity analysis of
epidemiological results as described in **Applying Quantitative Bias
Analysis to Epidemiological Data, 2<sup>nd</sup> ed.** by Matthew P.
Fox, Richard F. MacLehose, and Timothy L. Lash ([ISBN:
978-3-030-82672-7](https://link.springer.com/book/10.1007/978-3-030-82673-4),
[bias.analysis](https://sites.google.com/site/biasanalysis/)). Example
of using **apisensr** is available in Banack, Smith and Bodnar:
*Application of a Web-based Tool for Quantitative Bias Analysis: The
Example of Misclassification Due to Self-reported Body Mass Index*
([Epidemiology
2024;35(3):359-367](https://pubmed.ncbi.nlm.nih.gov/38300118/)).

## License

This package is free and open source software, licensed under GPL-2.

## Citation

To cite **apisensr**, please use:

``` r
citation("apisensr")
#> To cite package 'apisensr' in publications use:
#> 
#>   Haine, Denis (2025). The apisensr Shiny app package: interface to
#>   episensr for sensitivity analysis of epidemiological results. R
#>   package version 2.0.0. https://codeberg.org/dhaine/apisensr. doi:
#>   10.32614/CRAN.package.apisensr.
#> 
#> A BibTeX entry for LaTeX users is
#> 
#>   @Misc{,
#>     title = {The apisensr Shiny app package: interface to episensr for sensitivity analysis of epidemiological results},
#>     author = {Denis Haine},
#>     year = {2025},
#>     note = {R package version 2.0.0},
#>     doi = {10.32614/CRAN.package.apisensr},
#>     url = {https://codeberg.org/dhaine/apisensr},
#>   }
```

## Installation

You can get the latest release from **CRAN**:

``` r
install.packages('apisensr')
```

Or install the development version from
[Codeberg](https://codeberg.org/) with **remotes** package:

``` r
#install.packages("remotes")
remotes::install_git("https://codeberg.org/dhaine/apisensr", ref = "develop")
```

## How to run apisensr

``` r
library(apisensr)
run_app()
```

Please note that the apisensr project is released with a Contributor
Code of Conduct. By contributing to this project, you agree to abide by
its terms.
