% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_hypothesis_test.R
\name{argmin.HT.gupta}
\alias{argmin.HT.gupta}
\title{Perform argmin hypothesis test using Gupta's method.}
\usage{
argmin.HT.gupta(
  data,
  r,
  sample.mean = NULL,
  stds = NULL,
  critical.val = NULL,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{data}{A n by p data matrix; each of its row is a p-dimensional sample.}

\item{r}{The dimension of interest for hypothesis test.}

\item{sample.mean}{The sample mean of the n samples in data; defaults to NULL. It can be calculated via colMeans(data).
If performing multiple tests across dimensions, pre-computing \code{sample.mean} and \code{critical.val}
can significantly reduce computation time.}

\item{stds}{A vector of the same (population) standard deviations for all dimensions; defaults to a vector of 1's.
These are used to standardize the sample means.}

\item{critical.val}{The quantile for the hypothesis test; defaults to NULL. It can be calculated via \link{get.quantile.gupta.selection}.
If your experiment involves hypothesis testing over more than one dimension, pass a quantile to speed up computation.}

\item{alpha}{The significance level of the hypothesis test; defaults to 0.05.}

\item{...}{Additional argument to \link{get.quantile.gupta.selection}.
A correct argument name needs to be specified if it is used.}
}
\value{
A list containing:\tabular{ll}{
   \code{test.stat} \tab The test statistic \cr
   \tab \cr
.   \code{critical.value} \tab The critical value for the hypothesis test. Being greater than it leads to a rejection. \cr
   \tab \cr
   \code{ans} \tab 'Reject' or 'Accept' \cr
}
}
\description{
Test whether a dimension is the argmin, using the method in \insertCite{gupta.1965}{argminCS}.
}
\note{
This method requires independence among the dimensions.
}
\references{
\insertRef{gupta.1965}{argminCS}

\insertRef{futschik.1995}{argminCS}
}
