% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{th}
\alias{th}
\title{Automatically found threshold class.}
\usage{
th(thresh, ignore_black, ignore_white, ignore_na, autothresh_method)
}
\arguments{
\item{thresh}{A scalar. The threshold.}

\item{ignore_black}{\code{TRUE} if black values were ignored during the
thresholding and \code{FALSE} otherwise.}

\item{ignore_white}{\code{TRUE} if white values were ignored during the
thresholding and \code{FALSE} otherwise.}

\item{ignore_na}{\code{TRUE} if \code{NA} values were ignored during the thresholding
and \code{FALSE} otherwise.}

\item{autothresh_method}{The name of the automatic thresholding method used.}
}
\value{
An object of class \code{th}.
}
\description{
A threshold found automatically via \code{\link[=auto_thresh]{auto_thresh()}}. It is a number (the
value of the threshold) with 4 attributes: \itemize{\item \code{ignore_black} is
\code{TRUE} if black values were ignored during the thresholding and \code{FALSE}
otherwise. \item \code{ignore_white} is \code{TRUE} if white values were ignored during
the thresholding and \code{FALSE} otherwise. \item \code{ignore_na} is \code{TRUE} if \code{NA}s
were ignored during the thresholding and \code{FALSE} otherwise. \item
\code{autothresh_method} details which automatic thresholding method was used.}
}
