% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instance_profile.R
\name{create_profile}
\alias{create_profile}
\alias{delete_profile}
\alias{get_profile}
\alias{list_profiles}
\title{Instance Profiles}
\usage{
create_profile(profile, path, ...)

delete_profile(profile, ...)

get_profile(profile, ...)

list_profiles(role, n, marker, path, ...)
}
\arguments{
\item{profile}{A character string specifying the name for the profile, or an object of class \dQuote{iam_instance_profile}.}

\item{path}{A character string specifying a path prefix in which to locate user(s), role(s), etc. See \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{Reference Identifiers} on the AWS Documentation for more information.}

\item{\dots}{Additional arguments passed to \code{\link{iamHTTP}}.}

\item{role}{A character string containing a role name or an object of class \dQuote{iam_role}.}

\item{n}{An integer specifying the number of responses to return.}

\item{marker}{A character string specifying a marker (from a previous response) to use in paginating results}
}
\value{
An object of class \dQuote{iam_instance_profile}.
}
\description{
Create, retrieve, list, and delete EC2 Instance Profiles
}
\references{
\href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html}{About Instance Profiles}
  \href{http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateInstanceProfile.html}{API Documentation: CreateInstanceProfile}
  \href{http://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteInstanceProfile.html}{API Documentation: DeleteInstanceProfile}
  \href{http://docs.aws.amazon.com/IAM/latest/APIReference/API_GetInstanceProfile.html}{API Documentation: GetInstanceProfile}
  \href{http://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfiles.html}{API Documentation: ListInstanceProfiles}
}
